VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   8790
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   13620
   LinkTopic       =   "Form1"
   ScaleHeight     =   8790
   ScaleWidth      =   13620
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtUSBHandlecheckAnswer 
      Height          =   285
      Left            =   10920
      TabIndex        =   44
      Top             =   1680
      Width           =   2295
   End
   Begin VB.CommandButton cmdUSBHandlecheck 
      Caption         =   "DEMO-CR95HF-A USB Handle Check"
      Height          =   375
      Left            =   7560
      TabIndex        =   42
      Top             =   1560
      Width           =   3255
   End
   Begin VB.CommandButton cmdUSBconnect 
      Caption         =   "DEMO-CR95HF-A USB connect"
      Height          =   375
      Left            =   7560
      TabIndex        =   38
      Top             =   600
      Width           =   3255
   End
   Begin VB.TextBox txtUSBconnectAnswer 
      Height          =   285
      Left            =   10920
      TabIndex        =   37
      Top             =   720
      Width           =   2295
   End
   Begin VB.TextBox txtPollingReadingAnswer 
      Height          =   285
      Left            =   8760
      TabIndex        =   36
      Top             =   6720
      Width           =   2655
   End
   Begin VB.CommandButton cmdPollingReading 
      Caption         =   "Polling Reading sequence"
      Height          =   375
      Left            =   6000
      TabIndex        =   35
      Top             =   6600
      Width           =   2535
   End
   Begin VB.TextBox txtNSSpulseAnswer 
      Height          =   285
      Left            =   8760
      TabIndex        =   34
      Top             =   7200
      Width           =   2775
   End
   Begin VB.CommandButton cmdSendNSSPulse 
      Caption         =   "Send interrupt pulse on NSS pin"
      Height          =   375
      Left            =   6000
      TabIndex        =   33
      Top             =   7080
      Width           =   2535
   End
   Begin VB.CheckBox chkInterfacePinState 
      Caption         =   "communication in SPI mode"
      Height          =   195
      Index           =   1
      Left            =   4440
      TabIndex        =   32
      Top             =   8280
      Width           =   2535
   End
   Begin VB.CheckBox chkInterfacePinState 
      Caption         =   "communication in UART mode"
      Height          =   195
      Index           =   0
      Left            =   4440
      TabIndex        =   31
      Top             =   8040
      Width           =   2535
   End
   Begin VB.TextBox txtGetInterfacePinStateAnswer 
      Height          =   285
      Left            =   3120
      TabIndex        =   30
      Top             =   7680
      Width           =   3255
   End
   Begin VB.CommandButton cmdGetInterfacePinState 
      Caption         =   "Get Interface Pin State"
      Height          =   375
      Left            =   360
      TabIndex        =   29
      Top             =   7560
      Width           =   2535
   End
   Begin VB.CommandButton cmdSendIRQPulse 
      Caption         =   "Send interrupt pulse on IRQ pin"
      Height          =   375
      Left            =   360
      TabIndex        =   28
      Top             =   7080
      Width           =   2535
   End
   Begin VB.TextBox txtSendIRQPulseAnswer 
      Height          =   285
      Left            =   3120
      TabIndex        =   27
      Top             =   7200
      Width           =   2655
   End
   Begin VB.CommandButton cmdResetSPI 
      Caption         =   "Reset SPI"
      Height          =   375
      Left            =   360
      TabIndex        =   26
      Top             =   6600
      Width           =   2535
   End
   Begin VB.TextBox txtResetSPIAnswer 
      Height          =   285
      Left            =   3120
      TabIndex        =   25
      Top             =   6720
      Width           =   2655
   End
   Begin VB.CommandButton cmdSTCmd_Idle 
      Caption         =   "Idle ""01070E03A200F801980001606000003F28"" with CR95HFDll_STCmd"
      Height          =   375
      Left            =   360
      TabIndex        =   24
      Top             =   5640
      Width           =   6375
   End
   Begin VB.TextBox txtSTCmd_Idle 
      Height          =   285
      Left            =   6960
      TabIndex        =   23
      Top             =   5760
      Width           =   2175
   End
   Begin VB.CommandButton cmdSTCmd_ISO15693 
      Caption         =   "ISO15693 ""010202010D"" with CR95HFDll_STCmd"
      Height          =   375
      Left            =   360
      TabIndex        =   22
      Top             =   5160
      Width           =   6375
   End
   Begin VB.TextBox txtSTCmd_ISO15693 
      Height          =   285
      Left            =   6960
      TabIndex        =   21
      Top             =   5280
      Width           =   2175
   End
   Begin VB.CommandButton cmdSTCmd_RdReg 
      Caption         =   "RgReg ""010803620100"" with CR95HFDll_STCmd"
      Height          =   375
      Left            =   360
      TabIndex        =   20
      Top             =   4680
      Width           =   6375
   End
   Begin VB.TextBox txtSTCmd_RdReg 
      Height          =   285
      Left            =   6960
      TabIndex        =   19
      Top             =   4800
      Width           =   2175
   End
   Begin VB.TextBox txtISO14443B_Initiate_Answer 
      Height          =   285
      Left            =   7320
      TabIndex        =   18
      Top             =   4200
      Width           =   2175
   End
   Begin VB.CommandButton cmdSendReceive_ISO14443B_Initiate 
      Caption         =   "ISO14443B Initiate"
      Height          =   375
      Left            =   5040
      TabIndex        =   17
      Top             =   4080
      Width           =   2175
   End
   Begin VB.TextBox txtISO15693_Inventory_Answer 
      Height          =   285
      Left            =   2640
      TabIndex        =   16
      Top             =   4200
      Width           =   2175
   End
   Begin VB.CommandButton cmdSendReceive_ISO15693_Inventory 
      Caption         =   "ISO15693 Inventory"
      Height          =   375
      Left            =   360
      TabIndex        =   15
      Top             =   4080
      Width           =   2175
   End
   Begin VB.TextBox txtISO14443B_SelectAnswer 
      Height          =   285
      Left            =   7320
      TabIndex        =   14
      Top             =   3600
      Width           =   2175
   End
   Begin VB.CommandButton cmdSelect_ISO14443B_protocol 
      Caption         =   "Select ISO14443B = ""0301"""
      Height          =   375
      Left            =   5040
      TabIndex        =   13
      Top             =   3480
      Width           =   2175
   End
   Begin VB.CommandButton cmdSelect_ISO15693_protocol 
      Caption         =   "Select ISO15693 = ""010D"""
      Height          =   375
      Left            =   360
      TabIndex        =   12
      Top             =   3480
      Width           =   2175
   End
   Begin VB.TextBox txtISO15693_SelectAnswer 
      Height          =   285
      Left            =   2640
      TabIndex        =   11
      Top             =   3600
      Width           =   2175
   End
   Begin VB.TextBox txtIdnAnswer 
      Height          =   285
      Left            =   2640
      TabIndex        =   10
      Top             =   2640
      Width           =   4335
   End
   Begin VB.CommandButton cmdIdnRequest 
      Caption         =   "Idn"
      Height          =   375
      Left            =   360
      TabIndex        =   9
      Top             =   2520
      Width           =   2175
   End
   Begin VB.CommandButton cmdFieldOff 
      Caption         =   "Field Off"
      Height          =   375
      Left            =   360
      TabIndex        =   8
      Top             =   2040
      Width           =   2175
   End
   Begin VB.TextBox txtFieldOffAnswer 
      Height          =   285
      Left            =   2640
      TabIndex        =   7
      Top             =   2160
      Width           =   4335
   End
   Begin VB.TextBox txtEchoAnswer 
      Height          =   285
      Left            =   2640
      TabIndex        =   6
      Top             =   1680
      Width           =   4335
   End
   Begin VB.CommandButton cmdEcho 
      Caption         =   "Echo"
      Height          =   375
      Left            =   360
      TabIndex        =   5
      Top             =   1560
      Width           =   2175
   End
   Begin VB.CommandButton cmdGetMCUrev 
      Caption         =   "Get MCU rev"
      Height          =   375
      Left            =   360
      TabIndex        =   4
      Top             =   1080
      Width           =   2175
   End
   Begin VB.TextBox txtMCUrev 
      Height          =   285
      Left            =   2640
      TabIndex        =   3
      Top             =   1200
      Width           =   1695
   End
   Begin VB.TextBox txtDllRev 
      Height          =   285
      Left            =   2640
      TabIndex        =   2
      Top             =   720
      Width           =   1695
   End
   Begin VB.CommandButton cmdGetDllRev 
      Caption         =   "Get DLL rev"
      Height          =   375
      Left            =   360
      TabIndex        =   1
      Top             =   600
      Width           =   2175
   End
   Begin VB.Label lblUSBHandlecheck 
      Caption         =   "To check USB connection"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   8040
      TabIndex        =   43
      Top             =   1200
      Width           =   3615
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   "Visual Basic 6 source code example for "
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   8640
      TabIndex        =   41
      Top             =   3000
      Width           =   4695
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "AN3954 version 3"
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   9840
      TabIndex        =   40
      Top             =   2640
      Width           =   2415
   End
   Begin VB.Label lblUSBconnect 
      Caption         =   "To be done first !"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   8040
      TabIndex        =   39
      Top             =   240
      Width           =   2175
   End
   Begin VB.Label lblWarning 
      Alignment       =   2  'Center
      Caption         =   "DEMO-CR95HF-A"
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   9840
      TabIndex        =   0
      Top             =   3360
      Width           =   2415
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdGetDllRev_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_GetDLLrev(strAnswer)

If (lngStatus = 0) Then
    txtDllRev.Text = strAnswer
Else
    txtDllRev.Text = "Error = no Dll found"
End If
  
End Sub

Private Sub cmdGetInterfacePinState_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

chkInterfacePinState(0).Value = vbUnchecked
chkInterfacePinState(1).Value = vbUnchecked

lngStatus = CR95HFDLL_getInterfacePinState(strAnswer)

If (lngStatus = 0) Then
    txtGetInterfacePinStateAnswer.Text = strAnswer
    If (Mid(strAnswer, 6, 1) = "0") Then
        chkInterfacePinState(0).Value = vbChecked
        chkInterfacePinState(1).Value = vbUnchecked
    ElseIf (Mid(strAnswer, 6, 1) = "1") Then
        chkInterfacePinState(0).Value = vbUnchecked
        chkInterfacePinState(1).Value = vbChecked
    Else
        DoEvents
        'error
    End If
Else
    txtGetInterfacePinStateAnswer.Text = "No answer from the DEMO-CR95HF-A board"
End If
    
End Sub

Private Sub cmdGetMCURev_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDLL_getMCUrev(strAnswer)

If (lngStatus = 0) Then
    txtMCUrev.Text = strAnswer
Else
    txtMCUrev.Text = "Error = no communication with STM32 MCU"
End If
  
End Sub

Private Sub cmdEcho_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_Echo(strAnswer)

If (lngStatus = 0) Then
    txtEchoAnswer.Text = strAnswer
Else
    txtEchoAnswer.Text = "No communication with DEMO-CR95HF-A board"
End If
  
End Sub

Private Sub cmdFieldOff_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_FieldOff(strAnswer)

If (lngStatus = 0) Then
    txtFieldOffAnswer.Text = strAnswer
Else
    txtFieldOffAnswer.Text = "Field Off request not executed"
End If
  
End Sub

Private Sub cmdIDnRequest_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_Idn(strAnswer)

If (lngStatus = 0) Then
    txtIdnAnswer.Text = strAnswer
Else
    txtIdnAnswer.Text = "Idn not sent back by the CR95HF IC"
End If
  
End Sub

Private Sub cmdSelect_ISO15693_protocol_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_Select("010D", strAnswer)

If (lngStatus = 0) Then
    txtISO15693_SelectAnswer.Text = strAnswer
Else
    txtISO15693_SelectAnswer.Text = "Select protocol ISO15693 not executed"
End If
  
End Sub

Private Sub cmdSelect_ISO14443B_protocol_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_Select("0301", strAnswer)

If (lngStatus = 0) Then
    txtISO14443B_SelectAnswer.Text = strAnswer
Else
    txtISO14443B_SelectAnswer.Text = "Select protocol ISO14443B not executed"
End If
  
End Sub

Private Sub cmdSendReceive_ISO15693_Inventory_Click()
Dim strTagResponse  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_SendReceive("260100", strTagResponse)

If (lngStatus = 0) Then
    txtISO15693_Inventory_Answer.Text = strTagResponse
Else
    txtISO15693_Inventory_Answer.Text = "No answer from the Tag"
End If
  
End Sub

Private Sub cmdSendReceive_ISO14443B_Initiate_Click()
Dim strTagResponse  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_SendReceive("0600", strTagResponse)

If (lngStatus = 0) Then
    txtISO14443B_Initiate_Answer.Text = strTagResponse
Else
    txtISO14443B_Initiate_Answer.Text = "No answer from the Tag"
End If
  
End Sub


Private Sub cmdSTCmd_RdReg_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

lngStatus = CR95HFDll_STCmd("010803620100", strAnswer)

If (lngStatus = 0) Then
    txtSTCmd_RdReg.Text = strAnswer
Else
    txtSTCmd_RdReg.Text = "Read register not executed properly"
End If

End Sub

Private Sub cmdSTCmd_ISO15693_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

txtSTCmd_ISO15693.Text = ""

lngStatus = CR95HFDll_STCmd("010202010D", strAnswer)

If (lngStatus = 0) Then
    txtSTCmd_ISO15693.Text = strAnswer
Else
    txtSTCmd_ISO15693.Text = "ISO15693 protocol not selected"
End If

End Sub

Private Sub cmdSTCmd_Idle_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

txtSTCmd_Idle.Text = ""

lngStatus = CR95HFDll_STCmd("01070E03A200F801980001606000003F28", strAnswer)

If (lngStatus = 0) Then
    txtSTCmd_Idle.Text = strAnswer
Else
    txtSTCmd_Idle.Text = "No Idn returned from CR95HF IC"
End If

End Sub

Private Sub cmdResetSPI_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

txtResetSPIAnswer.Text = ""

lngStatus = CR95HFDll_ResetSPI(strAnswer)

If (lngStatus = 0) Then
    txtResetSPIAnswer.Text = strAnswer
Else
    txtResetSPIAnswer.Text = "No answer from the DEMO-CR95HF-A board"
End If
    
End Sub

Private Sub cmdSendIRQPulse_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

txtSendIRQPulseAnswer.Text = ""

lngStatus = CR95HFDll_SendIRQPulse(strAnswer)

If (lngStatus = 0) Then
    txtSendIRQPulseAnswer.Text = strAnswer
Else
    txtSendIRQPulseAnswer.Text = "No answer from the DEMO-CR95HF-A board"
End If
    
End Sub

Private Sub cmdUSBconnect_Click()
Dim lngStatus As Long

txtUSBconnectAnswer.Text = ""

lngStatus = CR95HFDLL_USBconnect()

If (lngStatus = 0) Then
    txtUSBconnectAnswer.Text = "DEMO-CR95HF-A connected and ready to be used"
Else
    txtUSBconnectAnswer.Text = "Warning : DEMO-CR95HF-A not connected"
End If
End Sub

Private Sub cmdPollingReading_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

txtPollingReadingAnswer.Text = ""

lngStatus = CR95HFDll_Polling_Reading(strAnswer)

If (lngStatus = 0) Then
    txtPollingReadingAnswer.Text = strAnswer
Else
    txtPollingReadingAnswer.Text = "No answer from the DEMO-CR95HF-A board"
End If
    
End Sub

Private Sub cmdSendNSSPulse_Click()
Dim strAnswer  As String * 256
Dim lngStatus As Long

txtNSSpulseAnswer.Text = ""

lngStatus = CR95HFDll_SendNSSPulse(strAnswer)

If (lngStatus = 0) Then
    txtNSSpulseAnswer.Text = strAnswer
Else
    txtNSSpulseAnswer.Text = "No answer from the DEMO-CR95HF-A board"
End If
    
End Sub

Private Sub cmdUSBHandlecheck_Click()
Dim lngStatus As Long

txtUSBHandlecheckAnswer.Text = ""

lngStatus = CR95HFDLL_USBhandlecheck()

If (lngStatus = 0) Then
    txtUSBHandlecheckAnswer.Text = "DEMO-CR95HF-A connected"
ElseIf (lngStatus = 5) Then
    txtUSBHandlecheckAnswer.Text = "DEMO-CR95HF-A not connected (use CR95HFDLL_USBconnect to connect it again"
End If

End Sub
